#!/usr/bin/bash

USER_ID=agent360
GROUP_ID=agent360

set -o nounset  # Treat unset variables as an error

# Check root privilege
if [ "$(id -u)" != "0" ]; then
   echo "error: Installer needs 'root' permission to run, please run as 'root'."
   exit 1
fi

# Parameter check
if [ $# -lt 1 ]; then
    echo "Userid parameter missing."
    exit 1
fi

# Setup the environment
echo "Setting up the 360 Agent operating environment"

chmod +x /usr/local/cpanel/scripts/agent360.sh
touch /var/log/agent360.log

# TODO: Configure the agent360.ini based on the server's current configuration

# Install the 360 Monitoring agent and other dependencies
/usr/local/cpanel/scripts/agent360.sh --skip-dep-install "$1"
rc=$?
if [ "$rc" != "0" ]; then
    >&2 echo The 360 Monitoring agent install failed with the error: $rc
    exit 1;
fi

#TODO: Consider changing the agent to run as root. We need to explore the implications of this since that means that risky stuff may happen from agent plugins.

#TODO: Setup the WHM service monitoring and enable the service and monitor by default.

exit 0;
